package app.firezone.synk.network.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;


import app.firezone.synk.network.R;
import app.firezone.synk.network.model.LotteryJoinedModel;

import java.util.ArrayList;

public class LotteryUsersAdapter extends RecyclerView.Adapter<LotteryUsersAdapter.holder> {

    ArrayList<LotteryJoinedModel> mlist;
    Context mContext;


    public LotteryUsersAdapter(ArrayList<LotteryJoinedModel> mlist, Context mContext){
        this.mlist = mlist;
        this.mContext = mContext;
    }

    @NonNull
    @Override
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.player_layout,parent,false);
        return new holder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull holder holder, @SuppressLint("RecyclerView") int position) {

        holder.player_name.setText(mlist.get(position).getName());

    }

    @Override
    public int getItemCount() {
        return mlist.size();
    }

    public class holder extends RecyclerView.ViewHolder {

        TextView player_name;
        public holder(@NonNull View itemView) {
            super(itemView);

            player_name= itemView.findViewById(R.id.playerName);


        }
    }
}
